//
//  CRImageData.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 8/3/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Image data
//////////////////////////////////////////////////////////////////////
@interface CRImageData : NSObject<NSCoding, NSCopying>
{
	NSString*		filePath;
	NSData*			fileData;
	NSDictionary*	generalProperties;
	NSDictionary*	imageProperties;
	CIImage*		image;
}

@property (nonatomic, readonly) NSString*		filePath;			// source file
@property (nonatomic, readonly) NSData*			fileData;			// source file data
@property (nonatomic, readonly) CIImage*		image;				// source image
@property (nonatomic, readonly) NSDictionary*	generalProperties;	// general props
@property (nonatomic, readonly) NSDictionary*	imageProperties;	// image props (EXIF)

- (id)initWithFilePath:(NSString *)file;

@end